#!/bin/bash

if [[ ! -f "/proc/device-tree/dcpr" ]]; then
  exit 0
fi

base_path=$0
script_name=$(basename $base_path)
[ -z "${REDIS_PORT}" ] && REDIS_PORT=30001

# Detect the present of shelf controller
ip_controller=$(redis-cli -c -p 50002 get "${REDIS_DATA_HASH_TAG}":so:mounts | jq -r '.[] | to_entries | .[] | select(.value.instance_type=="CONF" and .value.node_type=="Controller") | .value.ip')
if [[ ! -z "${ip_controller}" ]]; then
  LOG "Found controller at ip: ${ip_controller}"
  REDIS_PORT=50001
fi

LOG "Running $script_name targeting redis port $REDIS_PORT"

# Default inband management tunnel for release <= 10.0
TUNNEL_DEFAULT_OLD="eth2"
TUNNEL_CURRENT=$(tiny_dh_client -d /tmp/device_handlers/vsc751x -c gets -a config/inbandManagementTunnel/ethernetInterface)
REDIS_CONF_PATH="${REDIS_CONF_HASH_TAG}:dh/switch:config/inbandManagementTunnel/ethernetInterface"

if [[ -z "$TUNNEL_CURRENT" ]]; then
  THROW 1 "Failed to get the current tunnel configuration!"
fi

# Configuration was not sent down
if [[ "$TUNNEL_CURRENT" == "null" ]]; then
  LOG "Invalid tunnel configuration from tiny: $TUNNEL_CURRENT, collect from redis instead..."
  TUNNEL_CURRENT=$(redis-cli -c -p ${REDIS_PORT} DH.GET  ${REDIS_CONF_PATH} | jq -r '.value')
  LOG "Current tunnel configuration from redis: $TUNNEL_CURRENT"
fi

# We do rewrite the current config so that it will be sticky and not be changed even if the default is changed in config.json
if [[ "$TUNNEL_CURRENT" == "$TUNNEL_DEFAULT_OLD" ]]; then
  TUNNEL_CONF_VALUE="{\"value\":\"${TUNNEL_CURRENT}\"}"
  LOG "Rewriting the current tunnel configuration: $TUNNEL_CONF_VALUE"
  result=$(redis-cli -c -p ${REDIS_PORT} DH.SET  ${REDIS_CONF_PATH} ${TUNNEL_CONF_VALUE})
  if [[ "$result" != "OK" ]]; then
    LOG "Failed to rewrite the current tunnel configuration: ${TUNNEL_CONF_VALUE}"
    THROW 1 "Failed to rewrite the current tunnel configuration!"
  fi
fi

exit 0
