#!/bin/bash

function usage {
    cat <<EOM
Usage: $(basename "$0") [OPTION]...

  -r, --runningversion    <release version>        runnning release version
  -i, --installingversion <release version>        installing release version
  -d, --directory         <path>                   path to persistent directory to update
  -h, --help                                       display help
EOM

	exit 2
}

# convert long options to getopt short ones
for arg in "$@"; do
  shift
  case "$arg" in
    "--help")                set -- "$@" "-h" ;;
    "--runningversion")      set -- "$@" "-r" ;;
    "--installingversion")   set -- "$@" "-i" ;;
    "--directory")           set -- "$@" "-d" ;;
    *)                       set -- "$@" "$arg"
  esac
done

RUNNING_RELEASE_VERSION=''
INSTALLING_RELEASE_VERSION=''

# A POSIX variable
OPTIND=1         # Reset in case getopts has been used previously in the shell.

while getopts "h?r:i:d:" opt; do
  case "$opt" in
    h|\?)
      usage
      exit 0
      ;;
    r)  RUNNING_RELEASE_VERSION=$OPTARG
      ;;
    i)  INSTALLING_RELEASE_VERSION=$OPTARG
      ;;
    d)  PERSISTENT_DIRECTORY=$OPTARG
      ;;
    esac
done

shift $((OPTIND-1))

[ "${1:-}" = "--" ] && shift

if [ -z $RUNNING_RELEASE_VERSION ]
then
  echo "Failed to get the running release version"
  exit 1
fi

if [ -z $INSTALLING_RELEASE_VERSION ]
then
  echo "Failed to get the installing release version"
  exit 1
fi

if [ ! -d "$PERSISTENT_DIRECTORY" ]
then
  echo "The directory $PERSISTENT_DIRECTORY does not exist."
  exit 1
else
  echo "Upgrade script will update the persistent content at : $PERSISTENT_DIRECTORY."
fi

if [[ "$RUNNING_RELEASE_VERSION" == "$INSTALLING_RELEASE_VERSION" ]]
then
  echo "Running version and installing version are the same."
else
  echo "Do not know upgrade path"
fi

exit 0
