#!/bin/bash

if [[ ! -f "/proc/device-tree/dcpr" ]]; then
  exit 0
fi

function check_correct_master() {
  LOG "Getting SC status"
  sc_role=$(redis-cli -p 50002 get "${REDIS_DATA_HASH_TAG}":so:mounts | jq -r '.[] | to_entries | .[] | select(.value.instance_type=="CONF" and .value.node_type=="Controller") | .value.status')
  LOG "SC role is " "${sc_role}" " according to data instance (this is empty if no SC exists in data mount table)"
  if test "$sc_role"; then
    LOG "Check role of SC in mount table. Role of SC: " "${sc_role}"
    if [[ "${sc_role}" != "Master" ]]; then
      LOG "SC exists in mount table but is not master. SC role is " "${sc_role}" " Aborting with error."
      THROW 1 "Shelf-controller must be master. Not possible to upgrade."
    fi
  fi
  if test -z "$sc_role"; then
    sc_in_conf=$(redis-cli -c -p 50001 get "${REDIS_CONF_HASH_TAG}":so:mounts | jq -r '.[] | to_entries | .[] | select(.value.node_type=="Controller") | .value.role')
    LOG "Checking if SC exists in mount table and if it exists it should be master. Role of SC: " "${sc_in_conf}"
    if test "$sc_in_conf"; then
      LOG "SC configured to master. Aborting with error."
      THROW 1 "Shelf-controller must be master. Not possible to upgrade."
    fi
  fi
}

LOG "Running CLOOP upgrade ports script. This script will convert WSS ports to CLOOP ports."
ip_controller=$(redis-cli -p 50002 get "${REDIS_DATA_HASH_TAG}":so:mounts | jq -r '.[] | to_entries | .[] | select(.value.status=="Master" and .value.instance_type=="CONF" and .value.node_type=="Controller") | .value.ip')
LOG "Got IP address to master" "${ip_controller}"

if test -z "$ip_controller"; then
  set_options="-c -p 30001"
else
  set_options="-h ${ip_controller} -c -p 50001"
fi

# Check that if SC exists in mount table it is master
check_correct_master

ports_add=()
for ((num = 1; num <= 96; num+=2))
do
  port_add=$(redis-cli ${set_options} dh.get "${REDIS_CONF_HASH_TAG}":dh/wss:config/module/add/channel/"${num}"/port | jq -r '.value')
  if test -z "$port_add"; then
    LOG "No WSS port found for " "${num}" "read portnumber " "${ports_add[num]}" "Aborting with error"
    THROW 1 "Could not convert data. Is shelf-controller master? Not possible to upgrade."
  else
    ports_add+=( "${port_add}" )
  fi;

done
LOG "The following ports are read from WSS " "${ports_add[@]}"

# use for loop to read all values and indexes
for (( num=1; num<=48; num++ ));
do
  PORTNAME=""
  if [[ "${ports_add[num-1]}" -eq 2 ]]; then
    PORTNAME="localAD"
  elif [[ "${ports_add[num-1]}" -eq 4 ]]; then
    PORTNAME="xc1"
  elif [[ "${ports_add[num-1]}" -eq 6 ]]; then
    PORTNAME="xc2"
  elif [[ "${ports_add[num-1]}" -eq 8 ]]; then
    PORTNAME="xc3"
  elif [[ "${ports_add[num-1]}" -eq 1 ]]; then
    PORTNAME="xc4Wss1"
  elif [[ "${ports_add[num-1]}" -eq 3 ]]; then
    PORTNAME="xc4Wss2"
  elif [[ "${ports_add[num-1]}" -eq 5 ]]; then
    PORTNAME="xc4Wss3"
  elif [[ "${ports_add[num-1]}" -eq 7 ]]; then
    PORTNAME="xc4Wss4"
  elif [[ "${ports_add[num-1]}" -eq 9 ]]; then
    PORTNAME="xc4Wss5"
  else
    LOG "Port name not possible to read for channel " "${num}" "read portnumber " "${ports_add[num-1]}"
    THROW 1 "Could not convert data. Is shelf-controller master? Not possible to upgrade."
  fi
  # Config new service key and set value of port in running database
  REDIS_PATH="config/client/${num}/wssPortName"
  NEW_NAME="{\"value\":\"${PORTNAME}\"}"
  result=$(redis-cli ${set_options} DEL ${REDIS_CONF_HASH_TAG}:dh/cloop:${REDIS_PATH})
  LOG "Deleted old key" "${REDIS_PATH}" "with options " "${set_options}" "with result " "${result}"
  result=$(redis-cli ${set_options} DH.CREATE_CONFIG_KEY ${REDIS_CONF_HASH_TAG} dh/cloop ${REDIS_PATH} ${NEW_NAME})
  if [[ "$result" != "OK" ]]; then
    LOG "Error: could not create new key in database for path" "${REDIS_PATH}" "with options" "${set_options}" "and value" "${NEW_NAME}" ", exiting with error"
    THROW 1 "Could not convert data. Is shelf-controller master? Not possible to upgrade."
  fi
  result=$(redis-cli ${set_options} DH.SET               ${REDIS_CONF_HASH_TAG}:dh/cloop:${REDIS_PATH} ${NEW_NAME})
  if [[ "$result" != "OK" ]]; then
    LOG "Error: failed to write to new key value in database for path" "${REDIS_PATH}" "with options" "${set_options}" "and value" "${NEW_NAME}" "Is there contact with the controller?"
    THROW 1 "Could not convert data. Is shelf-controller master? Not possible to upgrade."
  fi
  LOG "Having set portname" "${PORTNAME}" "on path" "${REDIS_CONF_HASH_TAG}" ":dh/cloop:" "${REDIS_PATH}" "with options" "${set_options}"
done
# Check that if SC exists in mount table it is master - we want to fail the upgrade if it is on wrong state
check_correct_master
LOG "Converted WSS data to cloop data"
exit 0